<?php

namespace App\Models\Task;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Task extends Model 
{

    protected $table = 'task';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'name', 'description', 'start_date', 'end_date', 'staff_id', 'member_id');
    protected $visible = array('name', 'description', 'start_date', 'end_date', 'member_id');

    public function getProject()
    {
        return $this->hasOne('Project', 'project_id');
    }

    public function getStaf()
    {
        return $this->hasMany('App\Models\Task\Staf');
    }

}